import pandas as pd  
import pickle 
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  

target_customer_segments = [1, 2]  # Replace this list with the target customer segments from the previous step     

# Summarize the key characteristics of each target customer segment   
summary = {}   
for segment in target_customer_segments:   
    segment_customers = credit_customers[credit_customers['cluster'] == segment]   
    summary[segment] = {   
        'average_age': segment_customers['age'].mean(),   
        'average_credit_amount': segment_customers['credit_amount'].mean(),   
        'employment_distribution': segment_customers['employment'].value_counts(normalize=True).to_dict(),   
        'savings_status_distribution': segment_customers['savings_status'].value_counts(normalize=True).to_dict(),   
        'credit_history_distribution': segment_customers['credit_history'].value_counts(normalize=True).to_dict()   
    } 

print("summary:\n", summary)    
pickle.dump(summary,open("./ref_result/summary.pkl","wb"))